clear all, close all, clc

%% 500e Low Range
load('BEV_EMmap.mat');
BEV.mass = 1350;                    % [kg]     WLTP test mass
BEV.wheelbase = 2.322;              % [m]      wheelbase
BEV.aCG = 0.45*BEV.wheelbase;       % [m]      front axle - CoG distance 
BEV.bCG = 0.55*BEV.wheelbase;       % [m]      rear axle - CoG distance
BEV.hCG = 0.3;                      % [m]      height CoG - Dati 500e LR
BEV.Af = 2.15;                      % [m2]     Frontal area
BEV.Cd = 0.33;                      % [-]      Drag coefficient
BEV.tireRRcoeff = 0.0045;           % [-]      Rolling Resistance Coeff f0
BEV.tireRollingRadius = 0.3;        % [m]      Wheel Radius - 185/65 R15
BEV.roadLoadA_N = 55.78;            % [N]      F0
BEV.roadLoadB_N_per_kph = 0;        % [N/kph]  F1
BEV.roadLoadC_N_per_kph2 = 0.0335;  % [N/kph2] F2
BEV.gearRatio = 13;                 % [-]      Single Gear Ratio
BEV.gearEfficiency = 0.97;          % [-]      Gear stage efficiency
BEV.power = 70;                     % [kW]     Electric Motor Power
BEV.battery = 23.7;                 % [kWh]    Low Range Battery Size
BEV.w_em_map = Speed;               % [rpm]    Speed Breakpoints EM map
BEV.T_em_pos_max = Tmax_pos;        % [Nm]     Max Positive Torque EM map
BEV.T_em_neg_max = Tmax_neg;        % [Nm]     Max Negative Torque EM map
figure()
    hold on
    plot(BEV.w_em_map,BEV.T_em_pos_max,'k')
    plot(BEV.w_em_map,BEV.T_em_neg_max,'k')
    title('BEV Max Torque')
clear("Tmax_pos","Tmax_neg","Speed")
